//
//  MCChangeRecord.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 03/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


enum {
	MCChangeRecordTypeUndefined = 0,
	MCChangeRecordTypeInsert = 1,
	MCChangeRecordTypeUpdate,
	MCChangeRecordTypeDelete,
	MCChangeRecordTypeTrash
};

typedef unsigned MCChangeRecordType;


@interface MCChangeRecord : NSObject<NSCoding> {

	NSString *uuid;
	MCChangeRecordType type;
	NSString *tableName;
	NSString *primaryKey;
	NSDate *timeStamp;
	NSMutableDictionary *fields;
}

@property (readonly, copy) NSString *uuid;
@property (readonly) MCChangeRecordType type;
@property (readonly, copy) NSString *tableName;
@property (readonly, copy) NSString *primaryKey;
@property (readonly, copy) NSDate *timeStamp;
@property (readwrite, retain) NSMutableDictionary *fields;

+ (NSString*)stringForType:(MCChangeRecordType)aType;
- (NSString*)typeAsString;

// designated initializer
// calling -init will throw an excption
// @throws NSInvalidArgumentException for an unsupported type, or if any of aName, aKey, or aDate are nil
+ (id)changeRecordWithType:(MCChangeRecordType)aType
				 tableName:(NSString *)aName
				primaryKey:(NSString *)aKey
				 timeStamp:(NSDate *)aDate
					fields:(NSDictionary *)theFields;

+ (id)changeRecordWithRawRow:(NSDictionary *)rowDictionary;

+ (void)printLogWhenCreating:(BOOL)flag;

@end
